/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.espa.utils;

import de.alamos.ioespa.data.config.EspaConfig;
import de.alamos.ioespa.espa.utils.serial.PortListener;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

@SuppressFBWarnings(value={"MS_MUTABLE_COLLECTION_PKGPROTECT"})
public abstract class AbstractPortInput {
    public static final Map<AbstractPortInput, PortListener> REGISTERED_PORTS = new HashMap();
    private transient String comPort = null;
    private final EspaConfig espaConfig;
    private boolean running;
    private PortListener portListener;

    protected AbstractPortInput(EspaConfig espaConfig) {
        this.espaConfig = espaConfig;
    }

    public void stopInput() {
        if (REGISTERED_PORTS.containsKey(this)) {
            PortListener listener = (PortListener)REGISTERED_PORTS.get(this);
            listener.closeSerialPort();
            REGISTERED_PORTS.remove(this);
        }
        this.running = false;
    }

    public PortListener getPort() {
        return (PortListener)REGISTERED_PORTS.get(this);
    }

    public void startInput() {
        this.portListener = new /* Unavailable Anonymous Inner Class!! */;
        this.portListener.config(this.espaConfig);
        boolean success = this.portListener.openSerialPort(this.comPort);
        if (success) {
            REGISTERED_PORTS.put(this, this.portListener);
            this.afterComStarted();
            this.running = true;
        }
    }

    protected abstract void newDataAvailable(byte[] var1);

    protected abstract void afterComStarted();

    @Generated
    public void setComPort(String comPort) {
        this.comPort = comPort;
    }

    @Generated
    public boolean isRunning() {
        return this.running;
    }

    @Generated
    public PortListener getPortListener() {
        return this.portListener;
    }
}

