/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioprint;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.alamos.firemergency.ioprint.responses.IOPrintMqttTestPrintRequest;
import de.alamos.ioespa.data.config.EWizardResponseStatus;
import de.alamos.ioespa.data.config.EWizardStep;
import de.alamos.ioespa.data.config.SetupWizardConfig;
import de.alamos.ioespa.data.mqtt.ESubTopic;
import de.alamos.ioespa.helper.Base64ConfigHelper;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.rest.requests.PasswordChangeRequest;
import de.alamos.ioespa.rest.requests.PasswordValidator;
import de.alamos.ioespa.rest.requests.StringConfigRequest;
import de.alamos.ioespa.rest.responses.ioprint.SetupWizard;
import de.alamos.ioespa.services.MqttService;
import de.alamos.ioespa.services.PasswordService;
import de.alamos.ioespa.services.config.ConfigurationService;
import de.alamos.ioespa.services.ioprint.PrinterService;
import de.alamos.ioespa.services.ioprint.TestService;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import net.sf.jasperreports.engine.JRException;
import org.slf4j.Logger;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"print"})
public class WizardService {
    public static final int MAX_DELAY_IF_ALARM_IS_TOO_OLD = 20;
    public static final int CHECK_MQTT_SLEEP = 10;
    private static final int FIRST_PRINT_SLEEP_IN_MS = 15000;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final PrinterService printerService;
    private final ConfigurationService configurationService;
    private final TestService testService;
    private final PasswordService passwordService;
    private final MqttService mqttService;
    private final JsonMapper mapper;

    public WizardService(PrinterService printerService, ConfigurationService configurationService, TestService testService, PasswordService passwordService, MqttService mqttService) {
        this.printerService = printerService;
        this.configurationService = configurationService;
        this.testService = testService;
        this.passwordService = passwordService;
        this.mqttService = mqttService;
        this.mapper = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new JavaTimeModule())).build();
    }

    public boolean isSetUpFinished() {
        SetupWizardConfig setupWizardConfig = this.configurationService.loadAppSetupWizard();
        return setupWizardConfig.isFinish();
    }

    public void updateStep(EWizardStep step) {
        this.configurationService.updateAppSetupWizardStep(step.getStep());
    }

    public int getStep() {
        return this.configurationService.loadAppSetupWizard().getStep();
    }

    public void finish() {
        this.configurationService.updateAppSetupWizardFinish();
    }

    public SetupWizard setupProgress() {
        Long time;
        ZonedDateTime zonedDateTime;
        SetupWizardConfig config = this.configurationService.loadAppSetupWizard();
        SetupWizard setupWizard = new SetupWizard();
        setupWizard.setFinish(config.isFinish());
        if (config.isFinish()) {
            return setupWizard;
        }
        setupWizard.setPrinters(this.printerService.getPrinterStatusList());
        if (setupWizard.getPrinters().isEmpty()) {
            this.reinstallPrinters();
            setupWizard.setPrinters(this.printerService.getPrinterStatusList());
        }
        setupWizard.setFe2PrintingOk(Boolean.valueOf(config.isFe2PrintingOk()));
        setupWizard.setLocalPrintingOk(Boolean.valueOf(config.isLocalPrintingOk()));
        setupWizard.setConfigurationOk(Boolean.valueOf(config.isConfigurationOk()));
        setupWizard.setMqttOk(Boolean.valueOf(config.isMqttOk()));
        setupWizard.setPasswordOk(Boolean.valueOf(config.isPasswordOk()));
        setupWizard.setFe2PrintingMessage(config.getFe2PrintingMessage());
        setupWizard.setLocalPrintingMessage(config.getLocalPrintingMessage());
        setupWizard.setConfigurationMessage(config.getConfigurationMessage());
        setupWizard.setMqttMessage(config.getMqttMessage());
        setupWizard.setPasswordMessage(config.getPasswordMessage());
        PasswordValidator validatingResult = new PasswordValidator();
        validatingResult.setLength(config.isPassLengthOk());
        validatingResult.setHasCapital(config.isPassHasCapital());
        validatingResult.setHasLowerCase(config.isPassHasLowerCase());
        validatingResult.setPassEquals(config.isPassEquals());
        validatingResult.setNotEmpty(config.isPassNotEmpty());
        validatingResult.setHasDigit(config.isPassHasDigit());
        setupWizard.setPasswordValidation(validatingResult);
        setupWizard.setStep(config.getStep());
        setupWizard.setFe2PrintingAlarmError(config.getFe2PrintingAlarmError());
        setupWizard.setFe2PrintingAlarmReceived(config.getFe2PrintingAlarmReceived());
        setupWizard.setFe2PrintingAlarmParsed(config.getFe2PrintingAlarmParsed());
        setupWizard.setFe2PrintingAlarmPrinting(config.getFe2PrintingAlarmPrinting());
        this.checkMQTT(config, setupWizard);
        if (config.isFe2PrintingOk() && config.getFe2PrintingAlarmReceived().equals(EWizardResponseStatus.Unknown.name()) && ChronoUnit.SECONDS.between(zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(time = config.getFe2PrintingAlarmSendingTime()), ZoneId.systemDefault()), ZonedDateTime.now()) >= 20L) {
            String error = String.format("IOPrint hat keinen Druckauftrag von FE2 nach %d Sekunden erhalten.", 20);
            this.configurationService.updateAppSetupWizardFe2PrintingAlarmReceived(error, EWizardResponseStatus.Fail);
            setupWizard.setFe2PrintingAlarmError(error);
            setupWizard.setFe2PrintingAlarmReceived(EWizardResponseStatus.Fail.name());
        }
        return setupWizard;
    }

    private void checkMQTT(SetupWizardConfig setupWizardConfig, SetupWizard setupWizard) {
        if (setupWizardConfig.getStep() == EWizardStep.MQTT_CHECK.getStep()) {
            try {
                TimeUnit.SECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        setupWizard.setMqttOk(Boolean.valueOf(this.mqttService.isConnected() && this.mqttService.getHasSubscription()));
        if (setupWizard.getMqttOk().booleanValue() && (setupWizardConfig.getStep() == EWizardStep.NEED_RESTART.getStep() || setupWizardConfig.getStep() == EWizardStep.MQTT_CHECK.getStep())) {
            this.configurationService.updateAppSetupWizardMqtt(setupWizard.getMqttOk(), "", EWizardStep.FE2_TEST_START.getStep());
            setupWizard.setStep(EWizardStep.FE2_TEST_START.getStep());
        }
    }

    public void postConfig(StringConfigRequest config) {
        Base64ConfigHelper configHelper;
        this.configurationService.updateAppSetupWizardStep(EWizardStep.CONFIGURATION_SAVED.getStep());
        try {
            configHelper = new Base64ConfigHelper(config.getContent());
        }
        catch (Exception e) {
            this.logger.warn("Fehler beim Verarbeiten der Konfiguration", (Throwable)e);
            this.configurationService.updateAppSetupWizardConfiguration(Boolean.valueOf(false), "Fehler beim Verarbeiten der Konfiguration. Bitte beachten Sie die Dokumentation.", EWizardStep.CONFIGURATION_SAVED.getStep());
            return;
        }
        this.mqttService.unsubscribe();
        this.configurationService.saveConfigToFile(configHelper.getMqttConfig());
        this.configurationService.saveZipPassword(configHelper.getZipPassword());
        this.logger.info("Einstellungen wurden aktualisiert");
        this.configurationService.updateAppSetupWizardConfiguration(Boolean.valueOf(true), "Einstellungen erfolgreich gespeichert. Das Programm muss neu gestartet werden um alle \u00c4nderungen zu \u00fcbernehmen", EWizardStep.NEED_RESTART.getStep());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localTestChecked() {
        boolean success = true;
        String message = "Druckauftrag erfolgreich verschickt";
        try {
            this.printerService.cancelAllJobs();
            File testPdf = this.testService.getTestPdf();
            this.printerService.print(testPdf, 1);
            Thread.sleep(15000L);
        }
        catch (IOException | JRException e) {
            this.logger.warn("Fehler beim Erstellen der Testseite", e);
            message = "Fehler beim Erstellen der Testseite";
            success = false;
        }
        catch (Exception e) {
            this.logger.warn("Druckfehler. M\u00f6glicherweise wurden keine aktiven Drucker gefunden.", (Throwable)e);
            message = "Druckfehler. M\u00f6glicherweise wurden keine aktiven Drucker gefunden.";
            success = false;
        }
        finally {
            this.configurationService.updateAppSetupWizardLocalPrinting(success, message, EWizardStep.LOCAL_TEST_FINISHED.getStep());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fe2TestChecked() {
        boolean success = true;
        String message = "Druckanfrage erfolgreich gesendet";
        try {
            this.configurationService.updateAppSetupWizardCleanFe2Printing();
            this.printerService.cancelAllJobs();
            IOPrintMqttTestPrintRequest ioPrintMqttTestPrintRequest = new IOPrintMqttTestPrintRequest(OffsetDateTime.now());
            String json = this.mapper.writeValueAsString((Object)ioPrintMqttTestPrintRequest);
            this.logger.debug("IOPrintMqttTestPrintRequest generated {}", (Object)json);
            this.mqttService.handleAlarm(json, ESubTopic.FE2TestPrintRequest);
        }
        catch (Exception e) {
            this.logger.warn("Fehler beim Senden der Nachricht", (Throwable)e);
            message = "Fehler beim Senden der Nachricht";
            success = false;
        }
        finally {
            this.configurationService.updateAppSetupWizardFe2Printing(Long.valueOf(System.currentTimeMillis()), Boolean.valueOf(success), message, EWizardStep.FE2_TEST_FINISHED.getStep());
        }
    }

    public void changePassword(PasswordChangeRequest request) {
        PasswordValidator validatePass = new PasswordValidator();
        if (!validatePass.validatePass(request)) {
            this.configurationService.updateAppSetupWizardPassword(validatePass, EWizardStep.CHANGE_PASSWORD_FINISHED.getStep());
            return;
        }
        this.passwordService.changePassword(request.getFirst());
        this.configurationService.updateAppSetupWizardPassword(Boolean.valueOf(true), "Passwort erfolgreich ge\u00e4ndert", EWizardStep.FINISHED.getStep());
    }

    public boolean isRestartingServicesDone() {
        return this.printerService.isRestartingServicesDone();
    }

    public void reinstallPrinters() {
        this.printerService.removeAllPrinters();
        this.printerService.createPrinter();
    }
}

