/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioespa;

import com.fazecast.jSerialComm.SerialPort;
import de.alamos.ioespa.data.config.EspaConfig;
import de.alamos.ioespa.espa.ESPAInput;
import de.alamos.ioespa.espa.utils.AbstractPortInput;
import de.alamos.ioespa.espa.utils.SerialLogCollector;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.services.config.EspaConfigService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"espa"})
public class EspaControlService {
    public static final String TTY_S_0 = "ttyS0";
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private List<ESPAInput> inputs = new ArrayList();
    private final EspaConfigService espaConfigService;
    private final SerialLogCollector serialLogCollector;

    public EspaControlService(EspaConfigService espaConfigService, SerialLogCollector serialLogCollector) {
        this.espaConfigService = espaConfigService;
        this.serialLogCollector = serialLogCollector;
    }

    public void restart() {
        this.logger.trace("Espa-Eing\u00e4nge werden neu gestartet");
        this.inputs.stream().filter(AbstractPortInput::isRunning).forEach(AbstractPortInput::stopInput);
        this.init();
    }

    public void init() {
        EspaConfig espaConfig = this.espaConfigService.getEspaConfig();
        SerialPort[] ports = SerialPort.getCommPorts();
        this.logger.trace("{} COM-Ports gefunden", (Object)ports.length);
        Arrays.stream(ports).forEach(port -> this.logger.trace("{}, {}, {}, {}", new Object[]{port.getSystemPortName(), port.getPortDescription(), port.getDescriptivePortName(), port.getBaudRate()}));
        this.inputs = Arrays.stream(ports).filter(port -> StringUtils.equals((CharSequence)port.getSystemPortName(), (CharSequence)TTY_S_0)).map(port -> {
            ESPAInput input = new ESPAInput(espaConfig, this.serialLogCollector);
            input.setComPort(port.getSystemPortName());
            return input;
        }).collect(Collectors.toList());
        if (this.inputs.isEmpty()) {
            this.inputs = Arrays.stream(ports).map(port -> {
                ESPAInput input = new ESPAInput(espaConfig, this.serialLogCollector);
                input.setComPort(port.getSystemPortName());
                return input;
            }).collect(Collectors.toList());
        }
        this.inputs.forEach(input -> {
            Thread thread = new Thread(() -> ((ESPAInput)input).startInput());
            thread.setDaemon(true);
            thread.start();
        });
    }

    public void stop() {
        this.inputs.forEach(AbstractPortInput::stopInput);
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public List<ESPAInput> getInputs() {
        return this.inputs;
    }

    @Generated
    public EspaConfigService getEspaConfigService() {
        return this.espaConfigService;
    }

    @Generated
    public SerialLogCollector getSerialLogCollector() {
        return this.serialLogCollector;
    }
}

