/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.alamos.firemergency.ioespa.config.IOEspaMqttHeartbeat;
import de.alamos.ioespa.IOEspaApplication;
import de.alamos.ioespa.data.config.ConfigHolder;
import de.alamos.ioespa.data.config.MqttConfig;
import de.alamos.ioespa.data.mqtt.ESubTopic;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.helper.exceptions.IOEspaMqttException;
import de.alamos.ioespa.rest.responses.ioprint.UpdaterPrinterStatusResponse;
import de.alamos.ioespa.rest.responses.status.EAppName;
import de.alamos.ioespa.services.AppInfoService;
import de.alamos.ioespa.services.LedService;
import de.alamos.ioespa.services.MqttService;
import de.alamos.ioespa.services.TimeService;
import de.alamos.ioespa.services.UpdatingService;
import de.alamos.ioespa.services.config.ConfigurationService;
import de.alamos.ioespa.services.encryption.EncryptionService;
import de.alamos.ioespa.services.ioprint.AlarmService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MqttService {
    public static final int MAX_LENGTH_TO_LOG = 200;
    public static final int MAX_CLIENTID_LENGTH = 20;
    public static final String CLIENTID_PREFFIX = "IOPRINT_";
    private final MqttConfig config;
    private final LedService ledService;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final EncryptionService encryptionService;
    private final TimeService timeService;
    private final ObjectMapper objectMapper;
    private final AppInfoService appInfoService;
    private MqttClient client;
    private MqttClient clientFallback;
    private String mqttErrorMsg;
    private final ConfigurationService configurationService;
    private final UpdatingService updatingService;
    private final List<String> clientIds = new ArrayList();
    private final ExecutorService scheduler = Executors.newCachedThreadPool();
    private final AtomicBoolean hasSubscription = new AtomicBoolean(false);
    private final ScheduledExecutorService reconnectionScheduler = Executors.newScheduledThreadPool(1);
    private final AtomicBoolean isReconnecting = new AtomicBoolean(false);
    private final AtomicInteger reconnectionAttempts = new AtomicInteger(0);
    private final AtomicLong lastSuccessfulConnection = new AtomicLong(0L);
    private final AtomicLong lastReconnectionAttempt = new AtomicLong(0L);
    private final AtomicLong lastDisconnectTime = new AtomicLong(0L);
    private ScheduledFuture<?> healthCheckTask;
    private static final int HEALTH_CHECK_INTERVAL_SECONDS = 30;
    private static final int FIRST_RECONNECT_DELAY_MS = 10000;
    private static final int SECOND_RECONNECT_DELAY_MS = 30000;
    private static final int RECONNECT_DELAY_INCREMENT_MS = 30000;
    private static final int MAX_RECONNECT_DELAY_MS = 300000;
    private static final int CONNECTION_TIMEOUT_MS = 10000;
    private static final int DISCONNECT_TIMEOUT_MS = 1000;
    private static final int MILLISECONDS_IN_SECOND = 1000;

    public MqttService(ConfigHolder configHolder, TimeService timeService, LedService ledService, EncryptionService encryptionService, AppInfoService appInfoService, ConfigurationService configurationService, UpdatingService updatingService) {
        this.config = configHolder.getMqttConfig();
        this.ledService = ledService;
        this.encryptionService = encryptionService;
        this.timeService = timeService;
        this.appInfoService = appInfoService;
        this.configurationService = configurationService;
        this.updatingService = updatingService;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (this.config == null) {
            this.logger.warn("Keine Konfiguration gefunden, Mqtt-Dienst wird nicht vollst\u00e4ndig gestartet.");
            configurationService.updateAppSetupWizardMqtt(Boolean.valueOf(false), "Keine Konfiguration gefunden, Mqtt-Dienst wird nicht vollst\u00e4ndig gestartet.");
            return;
        }
        this.init();
        this.startHealthCheck();
    }

    private void startHealthCheck() {
        if (this.healthCheckTask != null && !this.healthCheckTask.isCancelled()) {
            this.healthCheckTask.cancel(false);
        }
        this.healthCheckTask = this.reconnectionScheduler.scheduleWithFixedDelay(() -> {
            try {
                this.checkConnectionHealth();
            }
            catch (Exception e) {
                this.logger.error("Error during health check", (Throwable)e);
            }
        }, 30L, 30L, TimeUnit.SECONDS);
        this.logger.info("MQTT health check started with interval {} seconds", (Object)30);
    }

    private void checkConnectionHealth() {
        boolean mainConnected = this.isConnected();
        boolean fallbackConnected = this.isFallbackConnected();
        if (!mainConnected && !fallbackConnected) {
            this.logger.warn("MQTT connections lost. Main: {}, Fallback: {}. Triggering reconnection...", (Object)mainConnected, (Object)fallbackConnected);
            this.ledService.setMqttLed(false);
            this.hasSubscription.set(false);
            this.triggerReconnection();
        } else if (mainConnected) {
            this.lastSuccessfulConnection.set(System.currentTimeMillis());
            if (this.reconnectionAttempts.get() > 0) {
                this.logger.info("MQTT connection restored. Resetting reconnection attempts.");
                this.reconnectionAttempts.set(0);
                this.ledService.setMqttLed(true);
                this.mqttErrorMsg = null;
            }
        }
    }

    private void triggerReconnection() {
        if (!this.isReconnecting.compareAndSet(false, true)) {
            this.logger.debug("Reconnection already in progress. Skipping.");
            return;
        }
        this.reconnectionScheduler.submit(() -> {
            try {
                this.performReconnection();
            }
            finally {
                this.isReconnecting.set(false);
            }
        });
    }

    private void performReconnection() {
        int attempts = this.reconnectionAttempts.incrementAndGet();
        long delay = this.calculateBackoffDelay(attempts);
        this.logger.info("MQTT reconnection attempt #{} in {} ms", (Object)attempts, (Object)delay);
        this.lastReconnectionAttempt.set(System.currentTimeMillis());
        try {
            Thread.sleep(delay);
            if (!this.isConnected()) {
                this.logger.info("Attempting to reconnect main MQTT client...");
                this.reconnectClient(this.client, "main");
            }
            if (!this.isFallbackConnected() && this.clientFallback != null) {
                this.logger.info("Attempting to reconnect fallback MQTT client...");
                this.reconnectClient(this.clientFallback, "fallback");
            }
            if (this.isConnected() || this.isFallbackConnected()) {
                this.logger.info("MQTT reconnection successful after {} attempts", (Object)attempts);
                this.reconnectionAttempts.set(0);
                this.lastSuccessfulConnection.set(System.currentTimeMillis());
                this.ledService.setMqttLed(true);
                this.mqttErrorMsg = null;
                this.resubscribeToTopics();
            } else {
                this.logger.warn("MQTT reconnection attempt #{} failed", (Object)attempts);
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("Reconnection interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.logger.error("Error during reconnection attempt #{}", (Object)attempts, (Object)e);
        }
    }

    private long calculateBackoffDelay(int attempts) {
        long delay = attempts == 1 ? 10000L : (long)(30000 + (attempts - 2) * 30000);
        return Math.min(delay, 300000L);
    }

    private void reconnectClient(MqttClient mqttClient, String clientType) {
        if (mqttClient == null) {
            this.logger.warn("Cannot reconnect {} client: client is null", (Object)clientType);
            return;
        }
        try {
            if (mqttClient.isConnected()) {
                this.logger.info("{} client already connected", (Object)clientType);
                return;
            }
            try {
                if (StringUtils.isNotBlank((CharSequence)this.config.getMqttBaseTopic()) && EAppName.IOPrint.equals((Object)this.appInfoService.getAppName())) {
                    mqttClient.unsubscribe(this.config.getMqttBaseTopic());
                    this.logger.debug("{} client unsubscribed from topic {} before reconnection", (Object)clientType, (Object)this.config.getMqttBaseTopic());
                }
            }
            catch (Exception e) {
                this.logger.debug("Error during unsubscribe of {} client (may be already disconnected): {}", (Object)clientType, (Object)e.getMessage());
            }
            try {
                mqttClient.disconnectForcibly(1000L);
            }
            catch (Exception e) {
                this.logger.debug("Error during force disconnect of {} client (may be already disconnected)", (Object)clientType);
            }
            MqttConnectOptions connectOptions = new MqttConnectOptions();
            connectOptions.setConnectionTimeout(10);
            connectOptions.setCleanSession(true);
            connectOptions.setAutomaticReconnect(false);
            if (this.config != null) {
                connectOptions.setUserName(this.config.getMqttUsername());
                if (StringUtils.isNotBlank((CharSequence)this.config.getMqttPassword())) {
                    connectOptions.setPassword(this.config.getMqttPassword().toCharArray());
                }
            }
            mqttClient.connect(connectOptions);
            this.logger.info("{} MQTT client reconnected successfully to {}", (Object)clientType, (Object)mqttClient.getServerURI());
        }
        catch (MqttException e) {
            this.logger.error("Failed to reconnect {} MQTT client", (Object)clientType, (Object)e);
            this.mqttErrorMsg = String.format("%s client reconnection failed: %s", clientType, e.getMessage());
        }
    }

    private void resubscribeToTopics() {
        if (StringUtils.isBlank((CharSequence)this.config.getMqttBaseTopic()) || !EAppName.IOPrint.equals((Object)this.appInfoService.getAppName())) {
            return;
        }
        try {
            if (this.isConnected()) {
                this.client.subscribe(this.config.getMqttBaseTopic());
                this.hasSubscription.set(true);
                this.logger.info("Resubscribed main client to topic {}", (Object)this.config.getMqttBaseTopic());
            }
        }
        catch (MqttException e) {
            this.logger.error("Failed to resubscribe main client to topic {}", (Object)this.config.getMqttBaseTopic(), (Object)e);
            this.hasSubscription.set(false);
        }
        try {
            if (this.isFallbackConnected()) {
                this.clientFallback.subscribe(this.config.getMqttBaseTopic());
                this.logger.info("Resubscribed fallback client to topic {}", (Object)this.config.getMqttBaseTopic());
            }
        }
        catch (MqttException e) {
            this.logger.error("Failed to resubscribe fallback client to topic {}", (Object)this.config.getMqttBaseTopic(), (Object)e);
        }
    }

    public boolean getHasSubscription() {
        return this.hasSubscription.get();
    }

    public void unsubscribe() {
        if (this.client != null && StringUtils.isNotBlank((CharSequence)this.config.getMqttBaseTopic()) && this.isConnected() && EAppName.IOPrint.equals((Object)this.appInfoService.getAppName())) {
            try {
                this.client.unsubscribe(this.config.getMqttBaseTopic());
                this.hasSubscription.set(false);
                this.logger.info("Successfully unsubscribed from the topic {}", (Object)this.config.getMqttBaseTopic());
            }
            catch (MqttException e) {
                this.logger.warn("Failed to unsubscribe from topic {}", (Object)this.config.getMqttBaseTopic());
            }
            if (this.clientFallback != null) {
                try {
                    this.clientFallback.unsubscribe(this.config.getMqttBaseTopic());
                    this.logger.info("Fallback successfully unsubscribed from the topic {}", (Object)this.config.getMqttBaseTopic());
                }
                catch (MqttException e) {
                    this.logger.warn("Fallback failed to unsubscribe from topic {}", (Object)this.config.getMqttBaseTopic());
                }
            }
        }
    }

    private synchronized AlarmService getAlarmService() {
        return (AlarmService)IOEspaApplication.getApplicationContext().getBean(AlarmService.class);
    }

    private synchronized UpdaterPrinterStatusResponse getUpdaterPrinterStatusResponse() {
        return (UpdaterPrinterStatusResponse)IOEspaApplication.getApplicationContext().getBean(UpdaterPrinterStatusResponse.class);
    }

    public boolean isConnected() {
        if (this.client == null) {
            return false;
        }
        return this.client.isConnected();
    }

    public boolean isFallbackConnected() {
        if (this.clientFallback == null) {
            return false;
        }
        return this.clientFallback.isConnected();
    }

    public int getReconnectionAttempts() {
        return this.reconnectionAttempts.get();
    }

    public long getCurrentReconnectionDelay() {
        int attempts = this.reconnectionAttempts.get();
        if (attempts == 0) {
            return 0L;
        }
        return this.calculateBackoffDelay(attempts);
    }

    public boolean isReconnecting() {
        return this.isReconnecting.get();
    }

    public long getLastDisconnectTime() {
        return this.lastDisconnectTime.get();
    }

    public long getLastSuccessfulConnection() {
        return this.lastSuccessfulConnection.get();
    }

    private void init() {
        Object clientId = CLIENTID_PREFFIX + UUID.randomUUID().toString();
        clientId = ((String)clientId).substring(0, Math.min(20, ((String)clientId).length()));
        this.logger.info("Verbinde mit Client-ID:{}", clientId);
        this.initMqttClient((String)clientId);
        this.initFallback((String)clientId);
    }

    private void initMqttClient(String clientId) {
        this.mqttErrorMsg = null;
        if (!this.config.isMqttActive()) {
            this.logger.warn("MQTT nicht aktiv");
            this.mqttErrorMsg = "MQTT nicht aktiv. Konfiguration pr\u00fcfen";
            this.configurationService.updateAppSetupWizardMqtt(Boolean.valueOf(false), "MQTT nicht aktiv. Konfiguration pr\u00fcfen");
            return;
        }
        try {
            if (this.client != null) {
                this.logger.warn("MQTT-Client bereits vorhanden. Stoppe diesen!");
                try {
                    this.client.disconnectForcibly();
                }
                catch (Exception e) {
                    this.logger.warn("Client konnte nicht getrennt werden");
                }
            }
            String url1 = String.format("%s:%s", this.config.getMqttServer1(), this.config.getMqttPort1());
            this.client = new MqttClient(url1, clientId, (MqttClientPersistence)new MqttDefaultFilePersistence("mqtt"));
            MqttConnectOptions connectOptions = new MqttConnectOptions();
            if (StringUtils.isNotBlank((CharSequence)this.config.getMqttServer2()) && this.config.getMqttPort2() != -1) {
                String url2 = String.format("%s:%s", this.config.getMqttServer2(), this.config.getMqttPort2());
                connectOptions.setServerURIs(new String[]{url1, url2});
            } else {
                connectOptions.setServerURIs(new String[]{url1});
            }
            connectOptions.setUserName(this.config.getMqttUsername());
            if (StringUtils.isNotBlank((CharSequence)this.config.getMqttPassword())) {
                connectOptions.setPassword(this.config.getMqttPassword().toCharArray());
            }
            connectOptions.setCleanSession(true);
            connectOptions.setAutomaticReconnect(true);
            this.clientIds.add(this.client.getClientId());
            this.client.setCallback((MqttCallback)new MqttCallbackHandler(this));
            this.client.connect(connectOptions);
            this.lastSuccessfulConnection.set(System.currentTimeMillis());
            this.ledService.setMqttLed(true);
        }
        catch (MqttException e) {
            this.logger.error("Fehler beim Initialisieren des Mqtt-Clients", (Throwable)e);
            this.ledService.setMqttLed(false);
            this.lastDisconnectTime.set(System.currentTimeMillis());
            Throwable cause = e.getCause();
            Object localizedMessage = e.getLocalizedMessage();
            if (cause instanceof UnknownHostException) {
                localizedMessage = "Keine Verbindung mit dem Host " + cause.getLocalizedMessage();
            }
            this.mqttErrorMsg = localizedMessage;
            this.configurationService.updateAppSetupWizardMqtt(Boolean.valueOf(false), "Fehler beim Initialisieren des Mqtt-Clients. " + e.getLocalizedMessage());
        }
    }

    private void initFallback(String clientId) {
        if (!this.config.isMqttActive()) {
            this.logger.warn("MQTT nicht aktiv. Fallback client not connected");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.config.getMqttFallbackServer())) {
            this.logger.warn("Fallback Server not configured. Fallback client not connected");
            return;
        }
        try {
            String url = String.format("%s:%s", this.config.getMqttFallbackServer(), this.config.getMqttFallbackPort());
            this.clientFallback = new MqttClient(url, clientId, (MqttClientPersistence)new MqttDefaultFilePersistence("mqtt"));
            MqttConnectOptions connectOptions = new MqttConnectOptions();
            connectOptions.setServerURIs(new String[]{url});
            connectOptions.setUserName(this.config.getMqttUsername());
            if (StringUtils.isNotBlank((CharSequence)this.config.getMqttPassword())) {
                connectOptions.setPassword(this.config.getMqttPassword().toCharArray());
            }
            connectOptions.setCleanSession(true);
            connectOptions.setAutomaticReconnect(true);
            this.clientFallback.setCallback((MqttCallback)new MqttCallbackHandler(this));
            this.clientFallback.connect(connectOptions);
        }
        catch (MqttException e) {
            this.logger.error("Fallback fehler beim Initialisieren des Mqtt-Clients", (Throwable)e);
        }
    }

    public void handleHeartbeat() throws IOEspaMqttException, JsonProcessingException {
        IOEspaMqttHeartbeat heartbeat = new IOEspaMqttHeartbeat(this.timeService.calculateUptime());
        String json = this.objectMapper.writeValueAsString((Object)heartbeat);
        this.handleHeartbeat(json);
    }

    public void handleHeartbeat(String json) throws IOEspaMqttException {
        if (this.config == null) {
            this.logger.warn("Config ist leer");
            return;
        }
        if (!this.config.isMqttActive()) {
            this.logger.warn("MQTT ist nicht aktiv. Heartbeat wird nicht verschickt");
            return;
        }
        if (this.client == null) {
            this.logger.error("Mqtt-Client nicht initialisiert");
            throw new IOEspaMqttException("MQTT-Client does not exist");
        }
        if (!this.client.isConnected()) {
            this.logger.error("Mqtt-Client ist aktuell nicht verbunden!");
            return;
        }
        MqttMessage mqttMessage = new MqttMessage(json.getBytes(StandardCharsets.UTF_8));
        Object baseTopic = this.config.getMqttBaseTopic();
        if (!((String)baseTopic).endsWith("/")) {
            baseTopic = (String)baseTopic + "/";
        }
        String topicName = String.format("%sHeartbeat", baseTopic);
        this.logger.trace("Heartbeat wird auf Topic {} gesendet", (Object)topicName);
        MqttTopic topic = this.client.getTopic(topicName);
        try {
            topic.publish(mqttMessage);
            this.logger.info("Heartbeat via MQTT versendet!");
        }
        catch (MqttException e) {
            this.logger.warn("Fehler beim Publish des Heartbeats", (Throwable)e);
            throw new IOEspaMqttException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public void handleAlarm(String message, ESubTopic subTopic) {
        String encrypted;
        if (!this.config.isMqttActive()) {
            this.logger.warn("MQTT ist nicht aktiv. Alarm wird nicht verschickt");
            return;
        }
        if (this.client == null) {
            this.logger.error("Mqtt-Client nicht initialisiert");
            return;
        }
        this.logger.info("MQTT-Message:\n{}", (Object)message);
        try {
            encrypted = this.encryptionService.encrypt(message);
        }
        catch (Exception e) {
            this.logger.warn("Fehler beim Verschl\u00fcsseln der Nachricht, breche MQTT-Versand ab", (Throwable)e);
            return;
        }
        MqttMessage mqttMessage = new MqttMessage(encrypted.getBytes());
        Object baseTopic = this.config.getMqttBaseTopic();
        if (!((String)baseTopic).endsWith("/")) {
            baseTopic = (String)baseTopic + "/";
        }
        String topicName = String.format("%s%s", baseTopic, subTopic);
        this.logger.info("Nachricht wird auf Topic '{}' und Host '{}' mit Client-ID '{}' gesendet...", new Object[]{topicName, this.client.getCurrentServerURI(), this.client.getClientId()});
        MqttTopic topic = this.client.getTopic(topicName);
        try {
            topic.publish(mqttMessage);
            this.logger.info("Alarm via MQTT versendet!");
        }
        catch (MqttException e) {
            this.logger.warn("Fehler beim Publish der MqttMessage", (Throwable)e);
        }
    }

    @Generated
    public String getMqttErrorMsg() {
        return this.mqttErrorMsg;
    }

    @Generated
    public List<String> getClientIds() {
        return this.clientIds;
    }
}

