/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.data.config;

import de.alamos.ioespa.data.config.ConfigFile;
import de.alamos.ioespa.helper.LoggerHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;

public class IOCredentials
implements ConfigFile,
Supplier<IOCredentials> {
    public static final String KEY_ZIP_PASSWORD = "zipPassword";
    public static final String KEY_SHARED_SECRET = "sharedSecret";
    public static final String KEY_SALT = "salt";
    public static final String KEY_WAS_CHANGED = "wasChanged";
    public static final int SALT_LENGTH_IN_BYTES = 16;
    public static final int PBKDF_ITERATION_COUNT = 65536;
    public static final int PBKDF_KEY_LENGTH = 128;
    private final SecureRandom random = new SecureRandom();
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private byte[] sharedSecret;
    private byte[] salt;
    private boolean wasChanged;
    private String zipPassword;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public IOCredentials(String defaultPassword) {
        this.changePassword(defaultPassword);
        this.zipPassword = "";
        this.wasChanged = false;
    }

    public IOCredentials(Properties properties) {
        this.sharedSecret = Base64.getDecoder().decode(properties.getProperty(KEY_SHARED_SECRET));
        this.salt = Base64.getDecoder().decode(properties.getProperty(KEY_SALT));
        this.zipPassword = properties.getProperty(KEY_ZIP_PASSWORD);
        this.wasChanged = Boolean.parseBoolean(properties.getProperty(KEY_WAS_CHANGED));
    }

    public Properties toProperties() {
        Properties props = new Properties();
        props.setProperty(KEY_SHARED_SECRET, Base64.getEncoder().encodeToString(this.sharedSecret));
        props.setProperty(KEY_SALT, Base64.getEncoder().encodeToString(this.salt));
        props.setProperty(KEY_ZIP_PASSWORD, this.zipPassword);
        props.setProperty(KEY_WAS_CHANGED, String.valueOf(this.wasChanged));
        return props;
    }

    public void changePassword(String newPassword) {
        byte[] salt = new byte[16];
        this.random.nextBytes(salt);
        try {
            this.sharedSecret = this.hashPassword(newPassword, salt);
            this.salt = salt;
            this.wasChanged = true;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            this.logger.error("Unerwarteter Fehler beim Hashing des Passworts", (Throwable)e);
        }
    }

    public boolean checkPassword(String password) {
        try {
            return Arrays.equals(this.hashPassword(password, this.salt), this.sharedSecret);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            this.logger.error("Unerwarteter Fehler beim Hashing des Passworts", (Throwable)e);
            return false;
        }
    }

    public byte[] hashPassword(String newPassword, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(newPassword.toCharArray(), salt, 65536, 128);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        return factory.generateSecret(spec).getEncoded();
    }

    public String generatePassword() {
        String upperCaseSet = "ABCDEFGHJKLMNPQRSTUVWXYZ";
        String lowerCaseSet = "abcdefghijkmnopqrstuvwxyz";
        String numberSet = "123456789";
        String upperCaseLetters = RandomStringUtils.random((int)2, (String)upperCaseSet);
        String lowerCaseLetters = RandomStringUtils.random((int)2, (String)lowerCaseSet);
        String numbers = RandomStringUtils.random((int)2, (String)numberSet);
        String totalChars = RandomStringUtils.random((int)2, (String)(upperCaseSet + lowerCaseSet + numberSet));
        String combinedChars = upperCaseLetters.concat(lowerCaseLetters).concat(numbers).concat(totalChars);
        List pwdChars = combinedChars.chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toList());
        Collections.shuffle(pwdChars);
        String password = pwdChars.stream().collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
        return password;
    }

    @Override
    public IOCredentials get() {
        return this;
    }

    @Generated
    public SecureRandom getRandom() {
        return this.random;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    @Generated
    public byte[] getSalt() {
        return this.salt;
    }

    @Generated
    public boolean isWasChanged() {
        return this.wasChanged;
    }

    @Generated
    public String getZipPassword() {
        return this.zipPassword;
    }

    @Generated
    public void setSharedSecret(byte[] sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    @Generated
    public void setSalt(byte[] salt) {
        this.salt = salt;
    }

    @Generated
    public void setWasChanged(boolean wasChanged) {
        this.wasChanged = wasChanged;
    }

    @Generated
    public void setZipPassword(String zipPassword) {
        this.zipPassword = zipPassword;
    }
}

