/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioprint;

import de.alamos.ioespa.helper.ExecuteCommandHelper;
import de.alamos.ioespa.services.ioprint.MemoryInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"print"})
public class MemoryService {
    private final ExecuteCommandHelper commandHelper;

    public MemoryService(ExecuteCommandHelper commandHelper) {
        this.commandHelper = commandHelper;
    }

    public List<MemoryInfo> getMemoryInfo() {
        return this.parse(this.commandHelper.getMemoryInfo());
    }

    public List<MemoryInfo> parse(String answer) {
        if (StringUtils.isBlank((CharSequence)answer)) {
            return new ArrayList<MemoryInfo>();
        }
        String[] split = answer.split("\n");
        return Arrays.stream(split).skip(1L).map(arg_0 -> this.parseMemo(arg_0)).collect(Collectors.toList());
    }

    private MemoryInfo parseMemo(String str) {
        String s = str.replaceAll("[ |\t]+", " ");
        String[] split = s.split(" ");
        return new MemoryInfo(split);
    }
}

