/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services;

import de.alamos.ioespa.data.config.ConfigHolder;
import de.alamos.ioespa.data.config.MqttConfig;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.rest.responses.status.ESystemStatus;
import de.alamos.ioespa.rest.responses.status.StatusResponse;
import de.alamos.ioespa.services.MqttService;
import de.alamos.ioespa.services.TimeService;
import de.alamos.ioespa.services.VersionService;
import de.alamos.ioespa.services.config.ConfigurationService;
import de.alamos.ioespa.services.ioespa.HttpAlarmService;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class StatusInfoService {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final MqttService mqttService;
    private final TimeService timeService;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z").withZone(ZoneId.of("Europe/Berlin"));
    private final MqttConfig ioConfig;
    private final VersionService versionService;
    private final HttpAlarmService httpAlarmService;
    private final ConfigurationService configurationService;

    public StatusInfoService(MqttService mqttService, TimeService timeService, ConfigHolder configHolder, VersionService versionService, HttpAlarmService httpAlarmService, ConfigurationService configurationService) {
        this.mqttService = mqttService;
        this.timeService = timeService;
        this.versionService = versionService;
        this.httpAlarmService = httpAlarmService;
        this.ioConfig = configHolder.getMqttConfig();
        this.configurationService = configurationService;
    }

    public StatusResponse getSystemStatus() {
        StatusResponse statusResponse = new StatusResponse();
        statusResponse.setStatus(this.getStatus());
        statusResponse.setStartingError(this.configurationService.isStartingError());
        Instant current = Instant.ofEpochMilli(this.timeService.getAdjustedSystemTime());
        statusResponse.setCurrentTimestamp(this.getFormatter().format(current));
        statusResponse.setMqttConnected(this.mqttService.isConnected());
        statusResponse.setIoespaVersion(this.versionService.getCurrentVersion());
        statusResponse.setSpringVersion(this.versionService.getSpringVersion());
        statusResponse.setJavaVersion(this.versionService.getJavaVersion());
        if (this.ioConfig != null) {
            statusResponse.setMqttActive(this.ioConfig.isMqttActive());
            statusResponse.setNtp(this.ioConfig.getNtp());
        }
        statusResponse.setHttpConfigured(this.httpAlarmService.isActive());
        statusResponse.setHttpEndpoint(this.httpAlarmService.getEndpoint());
        Instant lastSync = Instant.ofEpochMilli(this.timeService.getLastSync());
        statusResponse.setLastNtpSync(this.getFormatter().format(lastSync));
        try {
            if (System.getProperty("os.name").contains("Win")) {
                statusResponse.setIp(InetAddress.getLocalHost().getHostAddress());
            } else {
                Process proc = Runtime.getRuntime().exec("hostname -I ");
                statusResponse.setIp(new String(proc.getInputStream().readAllBytes(), StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            this.logger.trace("Fehler beim Holen der IP-Adresse", (Throwable)e);
        }
        statusResponse.setUptime(this.timeService.calculateUptime());
        statusResponse.setMissingConfig(this.ioConfig == null);
        return statusResponse;
    }

    private ESystemStatus getStatus() {
        if (this.ioConfig == null) {
            return ESystemStatus.ERROR;
        }
        if (!this.ioConfig.isMqttActive() || !this.mqttService.isConnected()) {
            return ESystemStatus.ERROR;
        }
        return ESystemStatus.OK;
    }

    private DateTimeFormatter getFormatter() {
        return this.formatter;
    }
}

