/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.alamos.firemergency.ioespa.config.IOEspaMqttHeartbeat;
import de.alamos.ioespa.IOEspaApplication;
import de.alamos.ioespa.data.config.ConfigHolder;
import de.alamos.ioespa.data.config.MqttConfig;
import de.alamos.ioespa.data.mqtt.ESubTopic;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.helper.exceptions.IOEspaMqttException;
import de.alamos.ioespa.rest.responses.ioprint.UpdaterPrinterStatusResponse;
import de.alamos.ioespa.rest.responses.status.EAppName;
import de.alamos.ioespa.services.AppInfoService;
import de.alamos.ioespa.services.LedService;
import de.alamos.ioespa.services.MqttService;
import de.alamos.ioespa.services.TimeService;
import de.alamos.ioespa.services.UpdatingService;
import de.alamos.ioespa.services.config.ConfigurationService;
import de.alamos.ioespa.services.encryption.EncryptionService;
import de.alamos.ioespa.services.ioprint.AlarmService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MqttService {
    public static final int MAX_LENGTH_TO_LOG = 200;
    private final MqttConfig config;
    private final LedService ledService;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final EncryptionService encryptionService;
    private final TimeService timeService;
    private final ObjectMapper objectMapper;
    private final AppInfoService appInfoService;
    private MqttClient client;
    private MqttClient clientFallback;
    private String mqttErrorMsg;
    private final ConfigurationService configurationService;
    private final UpdatingService updatingService;
    private final List<String> clientIds = new ArrayList();
    private final ExecutorService scheduler = Executors.newCachedThreadPool();
    private final AtomicBoolean hasSubscription = new AtomicBoolean(false);

    public MqttService(ConfigHolder configHolder, TimeService timeService, LedService ledService, EncryptionService encryptionService, AppInfoService appInfoService, ConfigurationService configurationService, UpdatingService updatingService) {
        this.config = configHolder.getMqttConfig();
        this.ledService = ledService;
        this.encryptionService = encryptionService;
        this.timeService = timeService;
        this.appInfoService = appInfoService;
        this.configurationService = configurationService;
        this.updatingService = updatingService;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (this.config == null) {
            this.logger.warn("Keine Konfiguration gefunden, Mqtt-Dienst wird nicht vollst\u00e4ndig gestartet.");
            configurationService.updateAppSetupWizardMqtt(Boolean.valueOf(false), "Keine Konfiguration gefunden, Mqtt-Dienst wird nicht vollst\u00e4ndig gestartet.");
            return;
        }
        this.init();
    }

    public boolean getHasSubscription() {
        return this.hasSubscription.get();
    }

    public void unsubscribe() {
        if (this.client != null && StringUtils.isNotBlank((CharSequence)this.config.getMqttBaseTopic()) && this.isConnected() && EAppName.IOPrint.equals((Object)this.appInfoService.getAppName())) {
            try {
                this.client.unsubscribe(this.config.getMqttBaseTopic());
                this.hasSubscription.set(false);
                this.logger.info("Successfully unsubscribed from the topic {}", (Object)this.config.getMqttBaseTopic());
            }
            catch (MqttException e) {
                this.logger.warn("Failed to unsubscribe from topic {}", (Object)this.config.getMqttBaseTopic());
            }
            if (this.clientFallback != null) {
                try {
                    this.clientFallback.unsubscribe(this.config.getMqttBaseTopic());
                    this.logger.info("Fallback successfully unsubscribed from the topic {}", (Object)this.config.getMqttBaseTopic());
                }
                catch (MqttException e) {
                    this.logger.warn("Fallback failed to unsubscribe from topic {}", (Object)this.config.getMqttBaseTopic());
                }
            }
        }
    }

    private synchronized AlarmService getAlarmService() {
        return (AlarmService)IOEspaApplication.getApplicationContext().getBean(AlarmService.class);
    }

    private synchronized UpdaterPrinterStatusResponse getUpdaterPrinterStatusResponse() {
        return (UpdaterPrinterStatusResponse)IOEspaApplication.getApplicationContext().getBean(UpdaterPrinterStatusResponse.class);
    }

    public boolean isConnected() {
        if (this.client == null) {
            return false;
        }
        return this.client.isConnected();
    }

    public boolean isFallbackConnected() {
        if (this.clientFallback == null) {
            return false;
        }
        return this.clientFallback.isConnected();
    }

    private void init() {
        String clientId = UUID.randomUUID().toString();
        this.logger.info("Verbinde mit Client-ID:{}", (Object)clientId);
        this.initMqttClient(clientId);
        this.initFallback(clientId);
    }

    private void initMqttClient(String clientId) {
        this.mqttErrorMsg = null;
        if (!this.config.isMqttActive()) {
            this.logger.warn("MQTT nicht aktiv");
            this.mqttErrorMsg = "MQTT nicht aktiv. Konfiguration pr\u00fcfen";
            this.configurationService.updateAppSetupWizardMqtt(Boolean.valueOf(false), "MQTT nicht aktiv. Konfiguration pr\u00fcfen");
            return;
        }
        try {
            if (this.client != null) {
                this.logger.warn("MQTT-Client bereits vorhanden. Stoppe diesen!");
                try {
                    this.client.disconnectForcibly();
                }
                catch (Exception e) {
                    this.logger.warn("Client konnte nicht getrennt werden");
                }
            }
            String url1 = String.format("%s:%s", this.config.getMqttServer1(), this.config.getMqttPort1());
            this.client = new MqttClient(url1, clientId, (MqttClientPersistence)new MqttDefaultFilePersistence("mqtt"));
            MqttConnectOptions connectOptions = new MqttConnectOptions();
            if (StringUtils.isNotBlank((CharSequence)this.config.getMqttServer2()) && this.config.getMqttPort2() != -1) {
                String url2 = String.format("%s:%s", this.config.getMqttServer2(), this.config.getMqttPort2());
                connectOptions.setServerURIs(new String[]{url1, url2});
            } else {
                connectOptions.setServerURIs(new String[]{url1});
            }
            connectOptions.setUserName(this.config.getMqttUsername());
            if (StringUtils.isNotBlank((CharSequence)this.config.getMqttPassword())) {
                connectOptions.setPassword(this.config.getMqttPassword().toCharArray());
            }
            connectOptions.setCleanSession(true);
            connectOptions.setAutomaticReconnect(true);
            this.clientIds.add(this.client.getClientId());
            this.client.setCallback((MqttCallback)new MqttCallbackHandler(this));
            this.client.connect(connectOptions);
            this.ledService.setMqttLed(true);
        }
        catch (MqttException e) {
            this.logger.error("Fehler beim Initialisieren des Mqtt-Clients", (Throwable)e);
            this.ledService.setMqttLed(false);
            Throwable cause = e.getCause();
            Object localizedMessage = e.getLocalizedMessage();
            if (cause instanceof UnknownHostException) {
                localizedMessage = "Keine Verbindung mit dem Host " + cause.getLocalizedMessage();
            }
            this.mqttErrorMsg = localizedMessage;
            this.configurationService.updateAppSetupWizardMqtt(Boolean.valueOf(false), "Fehler beim Initialisieren des Mqtt-Clients. " + e.getLocalizedMessage());
        }
    }

    private void initFallback(String clientId) {
        if (!this.config.isMqttActive()) {
            this.logger.warn("MQTT nicht aktiv. Fallback client not connected");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.config.getMqttFallbackServer())) {
            this.logger.warn("Fallback Server not configured. Fallback client not connected");
            return;
        }
        try {
            String url = String.format("%s:%s", this.config.getMqttFallbackServer(), this.config.getMqttFallbackPort());
            this.clientFallback = new MqttClient(url, clientId, (MqttClientPersistence)new MqttDefaultFilePersistence("mqtt"));
            MqttConnectOptions connectOptions = new MqttConnectOptions();
            connectOptions.setServerURIs(new String[]{url});
            connectOptions.setUserName(this.config.getMqttUsername());
            if (StringUtils.isNotBlank((CharSequence)this.config.getMqttPassword())) {
                connectOptions.setPassword(this.config.getMqttPassword().toCharArray());
            }
            connectOptions.setCleanSession(true);
            connectOptions.setAutomaticReconnect(true);
            this.clientFallback.setCallback((MqttCallback)new MqttCallbackHandler(this));
            this.clientFallback.connect(connectOptions);
        }
        catch (MqttException e) {
            this.logger.error("Fallback fehler beim Initialisieren des Mqtt-Clients", (Throwable)e);
        }
    }

    public void handleHeartbeat() throws IOEspaMqttException, JsonProcessingException {
        IOEspaMqttHeartbeat heartbeat = new IOEspaMqttHeartbeat(this.timeService.calculateUptime());
        String json = this.objectMapper.writeValueAsString((Object)heartbeat);
        this.handleHeartbeat(json);
    }

    public void handleHeartbeat(String json) throws IOEspaMqttException {
        if (this.config == null) {
            this.logger.warn("Config ist leer");
            return;
        }
        if (!this.config.isMqttActive()) {
            this.logger.warn("MQTT ist nicht aktiv. Heartbeat wird nicht verschickt");
            return;
        }
        if (this.client == null) {
            this.logger.error("Mqtt-Client nicht initialisiert");
            throw new IOEspaMqttException("MQTT-Client does not exist");
        }
        if (!this.client.isConnected()) {
            this.logger.error("Mqtt-Client ist aktuell nicht verbunden!");
            return;
        }
        MqttMessage mqttMessage = new MqttMessage(json.getBytes(StandardCharsets.UTF_8));
        Object baseTopic = this.config.getMqttBaseTopic();
        if (!((String)baseTopic).endsWith("/")) {
            baseTopic = (String)baseTopic + "/";
        }
        String topicName = String.format("%sHeartbeat", baseTopic);
        this.logger.trace("Heartbeat wird auf Topic {} gesendet", (Object)topicName);
        MqttTopic topic = this.client.getTopic(topicName);
        try {
            topic.publish(mqttMessage);
            this.logger.info("Heartbeat via MQTT versendet!");
        }
        catch (MqttException e) {
            this.logger.warn("Fehler beim Publish des Heartbeats", (Throwable)e);
            throw new IOEspaMqttException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public void handleAlarm(String message, ESubTopic subTopic) {
        String encrypted;
        if (!this.config.isMqttActive()) {
            this.logger.warn("MQTT ist nicht aktiv. Alarm wird nicht verschickt");
            return;
        }
        if (this.client == null) {
            this.logger.error("Mqtt-Client nicht initialisiert");
            return;
        }
        this.logger.info("MQTT-Message:\n{}", (Object)message);
        try {
            encrypted = this.encryptionService.encrypt(message);
        }
        catch (Exception e) {
            this.logger.warn("Fehler beim Verschl\u00fcsseln der Nachricht, breche MQTT-Versand ab", (Throwable)e);
            return;
        }
        MqttMessage mqttMessage = new MqttMessage(encrypted.getBytes());
        Object baseTopic = this.config.getMqttBaseTopic();
        if (!((String)baseTopic).endsWith("/")) {
            baseTopic = (String)baseTopic + "/";
        }
        String topicName = String.format("%s%s", baseTopic, subTopic);
        this.logger.info("Nachricht wird auf Topic '{}' und Host '{}' mit Client-ID '{}' gesendet...", new Object[]{topicName, this.client.getCurrentServerURI(), this.client.getClientId()});
        MqttTopic topic = this.client.getTopic(topicName);
        try {
            topic.publish(mqttMessage);
            this.logger.info("Alarm via MQTT versendet!");
        }
        catch (MqttException e) {
            this.logger.warn("Fehler beim Publish der MqttMessage", (Throwable)e);
        }
    }

    @Generated
    public String getMqttErrorMsg() {
        return this.mqttErrorMsg;
    }

    @Generated
    public List<String> getClientIds() {
        return this.clientIds;
    }
}

