/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioprint;

import de.alamos.ioespa.data.printing.PrinterStatusPreparedForPdf;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.rest.responses.status.StatusResponse;
import de.alamos.ioespa.services.ioprint.IOPrintStatusInfoService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import org.slf4j.Logger;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"print"})
@SuppressFBWarnings(value={"UI_INHERITANCE_UNSAFE_GETRESOURCE"})
public class TestService {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final IOPrintStatusInfoService statusInfoService;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss z");

    public TestService(IOPrintStatusInfoService statusInfoService) {
        this.statusInfoService = statusInfoService;
    }

    public File getTestPdf() throws JRException, IOException {
        return this.getTestPdf(false);
    }

    public File getTestPdf(boolean withIpConfig) throws JRException, IOException {
        StatusResponse statusResponse = this.statusInfoService.getSystemStatus();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("STATUS", statusResponse.getStatus().name());
        parameters.put("currentTimestamp", statusResponse.getCurrentTimestamp());
        parameters.put("ip", statusResponse.getIp());
        parameters.put("lastNtpSync", statusResponse.getLastNtpSync());
        parameters.put("javaVersion", statusResponse.getJavaVersion());
        parameters.put("springVersion", statusResponse.getSpringVersion());
        parameters.put("version", statusResponse.getIoespaVersion());
        parameters.put("uptime", statusResponse.getUptime());
        parameters.put("isMqttActive", statusResponse.isMqttActive());
        parameters.put("isMqttConnected", statusResponse.isMqttConnected());
        parameters.put("isSubscriber", statusResponse.isSubscriber());
        parameters.put("isFrpRunning", statusResponse.isFrpRunning());
        if (withIpConfig) {
            parameters.put("ipConfig", statusResponse.getIpConfig());
        }
        ZonedDateTime dateTime = new Date().toInstant().atZone(ZoneId.of("Europe/Berlin"));
        parameters.put("date", dateTime.format(DATE_FORMAT));
        parameters.put("time", dateTime.format(TIME_FORMAT));
        List printerStatusPreparedForPdfs = statusResponse.getPrinters().stream().map(PrinterStatusPreparedForPdf::new).collect(Collectors.toList());
        parameters.put("printers", new JRBeanCollectionDataSource(printerStatusPreparedForPdfs));
        this.logger.debug("Testausdruck info ready {}", (Object)statusResponse);
        InputStream employeeReportStream = this.getClass().getResourceAsStream("/testReportTemplate.jrxml");
        this.logger.debug("Template file '/testReportTemplate.jrxml' successfully found");
        JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)employeeReportStream);
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)new JREmptyDataSource());
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        File tmp = File.createTempFile("testReport" + exporter.hashCode(), ".pdf");
        this.logger.debug("TempFile created at path {}", (Object)tmp.getAbsolutePath());
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)tmp.getAbsolutePath());
        exporter.exportReport();
        return tmp;
    }
}

