/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller.ioespa;

import de.alamos.ioespa.IOEspaApplication;
import de.alamos.ioespa.espa.utils.serial.PortListener;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.rest.responses.status.ComPortStatus;
import de.alamos.ioespa.rest.responses.status.EAppName;
import de.alamos.ioespa.rest.responses.status.ESystemStatus;
import de.alamos.ioespa.rest.responses.status.StatusResponse;
import de.alamos.ioespa.services.StatusInfoService;
import de.alamos.ioespa.services.ioespa.EspaControlService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@Profile(value={"espa"})
public class StatusController {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final StatusInfoService statusInfoService;
    private final EspaControlService espaControlService;

    public StatusController(StatusInfoService statusInfoService, EspaControlService espaControlService) {
        this.statusInfoService = statusInfoService;
        this.espaControlService = espaControlService;
    }

    @GetMapping(value={"/status"})
    public String getSystemStatus(Model model, String error) {
        model.addAttribute("error", (Object)error);
        StatusResponse statusResponse = this.statusInfoService.getSystemStatus();
        statusResponse.setCom(this.getComPortStatusList());
        statusResponse.setStatus(this.updateStatus(statusResponse.getStatus(), statusResponse.getCom()));
        model.addAttribute("response", (Object)statusResponse);
        model.addAttribute("appName", (Object)EAppName.IOEspa);
        model.addAttribute("isRestartingServicesDone", (Object)true);
        return "status";
    }

    private ESystemStatus updateStatus(ESystemStatus status, List<ComPortStatus> com) {
        if (CollectionUtils.isEmpty(com)) {
            return ESystemStatus.ERROR;
        }
        if (com.stream().filter(ComPortStatus::isConnected).findAny().isEmpty()) {
            return ESystemStatus.ERROR;
        }
        if (com.stream().filter(ComPortStatus::isEspa).findAny().isEmpty()) {
            return ESystemStatus.ERROR;
        }
        return ESystemStatus.OK;
    }

    @GetMapping(value={"/restart"})
    public String restart(RedirectAttributes redirAttrs) {
        this.logger.info("Anwendung wird neu gestartet...");
        IOEspaApplication.restart();
        redirAttrs.addFlashAttribute("success", (Object)"Anwendung wird neu gestartet");
        return "redirect:/status";
    }

    private List<ComPortStatus> getComPortStatusList() {
        return this.espaControlService.getInputs().stream().filter(input -> input.getPort() != null).map(input -> {
            PortListener portListener = input.getPortListener();
            ComPortStatus comPortStatus = new ComPortStatus();
            comPortStatus.setName(portListener.getName());
            comPortStatus.setConnected(input.getPort() != null);
            comPortStatus.setLastAlarms(input.getLastAlarms());
            comPortStatus.setEspa(input.hasEspaHeartbeat());
            return comPortStatus;
        }).collect(Collectors.toList());
    }
}

