/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller;

import de.alamos.ioespa.data.config.IOCredentials;
import de.alamos.ioespa.rest.requests.PasswordChangeRequest;
import de.alamos.ioespa.rest.requests.PasswordValidator;
import de.alamos.ioespa.services.AppInfoService;
import de.alamos.ioespa.services.PasswordService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class PasswordController {
    private final IOCredentials credentials;
    private final PasswordService passwordService;
    private final AppInfoService appInfoService;

    public PasswordController(IOCredentials credentials, PasswordService passwordService, AppInfoService appInfoService) {
        this.credentials = credentials;
        this.passwordService = passwordService;
        this.appInfoService = appInfoService;
    }

    @GetMapping(value={"/password"})
    public String getPage(RedirectAttributes redirAttrs, Model model) {
        model.addAttribute("config", (Object)new PasswordChangeRequest());
        model.addAttribute("defaultPassword", (Object)(!this.credentials.isWasChanged() ? 1 : 0));
        model.addAttribute("appName", (Object)this.appInfoService.getAppName());
        return "password";
    }

    @PostMapping(value={"/password"})
    public String postConfig(@ModelAttribute PasswordChangeRequest request, RedirectAttributes redirAttrs) {
        PasswordValidator validatePass = new PasswordValidator();
        if (!validatePass.validatePass(request)) {
            redirAttrs.addFlashAttribute("error", (Object)validatePass);
            return "redirect:/password";
        }
        this.passwordService.changePassword(request.getFirst());
        redirAttrs.addFlashAttribute("success", (Object)"Passwort erfolgreich ge\u00e4ndert");
        return "redirect:/status";
    }
}

