/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioprint;

import de.alamos.ioespa.data.config.ConfigHolder;
import de.alamos.ioespa.helper.ExecuteCommandHelper;
import de.alamos.ioespa.helper.LoggerHelper;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"print"})
public class ResumingService {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final Long resumingInterval = 2L;
    private final ScheduledExecutorService executorService;
    private final ExecuteCommandHelper commandHelper;
    private boolean resumingEnabled = false;

    public ResumingService(ConfigHolder configHolder, ExecuteCommandHelper commandHelper) {
        this.commandHelper = commandHelper;
        this.executorService = Executors.newScheduledThreadPool(1);
        this.executorService.scheduleAtFixedRate(() -> this.schedule(), 1L, this.resumingInterval, TimeUnit.MINUTES);
    }

    public void enableResuming() {
        this.resumingEnabled = true;
    }

    private void schedule() {
        if (!this.resumingEnabled) {
            this.logger.trace("schedule ResumingService disabled");
            return;
        }
        this.logger.debug("schedule ResumingService run");
        List printers = this.commandHelper.getOfflinePrintersList();
        this.resumingEnabled = printers.isEmpty();
        printers.forEach(arg_0 -> ((ExecuteCommandHelper)this.commandHelper).resumePrinter(arg_0));
    }
}

