/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioprint;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.alamos.firemergency.ioprint.responses.IOPrintMqttHeartbeat;
import de.alamos.firemergency.ioprint.responses.PrinterStatusResponse;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.rest.responses.status.StatusResponse;
import de.alamos.ioespa.services.HeartbeatService;
import de.alamos.ioespa.services.MqttService;
import de.alamos.ioespa.services.TimeService;
import de.alamos.ioespa.services.ioprint.IOPrintStatusInfoService;
import de.alamos.ioespa.services.ioprint.PrinterService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"print"})
public class HeartbeatServicePrint
implements HeartbeatService {
    public static final int HEARTBEAT_INIT_DELAY_IN_M = 1;
    public static final int HEARTBEAT_SCHEDULE_IN_M = 10;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final ObjectMapper objectMapper;
    private final PrinterService printerService;
    private final TimeService timeService;
    private final IOPrintStatusInfoService statusInfoService;
    private final MqttService mqttService;
    private final ScheduledExecutorService executorService;

    public HeartbeatServicePrint(PrinterService printerService, TimeService timeService, IOPrintStatusInfoService statusInfoService, MqttService mqttService) {
        this.printerService = printerService;
        this.timeService = timeService;
        this.statusInfoService = statusInfoService;
        this.mqttService = mqttService;
        this.executorService = Executors.newScheduledThreadPool(1);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void scheduleHeartbeat() {
        this.executorService.scheduleAtFixedRate(() -> this.sendHeartbeat(), 1L, 10L, TimeUnit.MINUTES);
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private void sendHeartbeat() {
        this.logger.trace("Sende Heartbeat...");
        try {
            List printers = this.printerService.getPrinterStatusList().stream().filter(PrinterStatusResponse::getEnable).collect(Collectors.toList());
            IOPrintMqttHeartbeat heartbeat = new IOPrintMqttHeartbeat(this.timeService.calculateUptime());
            heartbeat.setPrinters(printers);
            StatusResponse systemStatus = this.statusInfoService.getSystemStatus();
            heartbeat.setVersion(systemStatus.getIoespaVersion());
            heartbeat.setIp(systemStatus.getIp());
            heartbeat.setNeedReboot(systemStatus.getNeedReboot());
            String json = this.objectMapper.writeValueAsString((Object)heartbeat);
            this.logger.debug("Heartbeat generated {}", (Object)json);
            this.mqttService.handleHeartbeat(json);
        }
        catch (Exception e) {
            this.logger.error("Heartbeat konnte nicht via MQTT verschickt werden", (Throwable)e);
        }
    }
}

