/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioespa;

import de.alamos.ioespa.data.config.ConfigHolder;
import de.alamos.ioespa.data.config.HttpAlarmConfig;
import de.alamos.ioespa.data.config.MqttConfig;
import de.alamos.ioespa.data.mqtt.ESubTopic;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.helper.exceptions.FE2HttpException;
import de.alamos.ioespa.helper.exceptions.GenericException;
import de.alamos.ioespa.services.MqttService;
import de.alamos.ioespa.services.config.HttpAlarmConfigService;
import de.alamos.ioespa.services.encryption.EncryptionService;
import de.alamos.ioespa.services.ioespa.AlarmCounter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
public class HttpAlarmService {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final int CONNECT_TIMEOUT_IN_S = 30;
    public static final int READ_WRITE_TIMEOUT_IN_S = 10;
    public static final int HERATBEAT_ID_LENGTH = 32;
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final HttpAlarmConfigService configService;
    private final MqttService mqttService;
    private final EncryptionService encryptionService;
    private final OkHttpClient client;
    private final MqttConfig mqttConfig;

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public HttpAlarmService(HttpAlarmConfigService configService, ConfigHolder configHolder, MqttService mqttService, EncryptionService encryptionService) {
        this.configService = configService;
        this.mqttService = mqttService;
        this.encryptionService = encryptionService;
        this.mqttConfig = configHolder.getMqttConfig();
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).retryOnConnectionFailure(true);
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustAllCerts[0]).hostnameVerifier((hostname, session) -> true);
        }
        catch (Exception exception) {
            this.logger.warn("Could not init trust all certificates client", (Throwable)exception);
        }
        this.client = builder.build();
    }

    public String getEndpoint() {
        return this.configService.getHttpAlarmConfig().getHost();
    }

    public boolean isActive() {
        return StringUtils.isNotBlank((CharSequence)this.configService.getHttpAlarmConfig().getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(String message, long id) {
        HttpAlarmConfig config = this.configService.getHttpAlarmConfig();
        String host = config.getHost();
        String url = String.format("%s/rest/external/ioespa/%s/alarm", host, this.mqttConfig.getId());
        this.logger.info("Verschicke Alarm via HTTP an {}...", (Object)url);
        try (Response response = null;){
            this.logger.debug("> {}", (Object)message);
            String encrypted = this.encryptionService.encrypt(message);
            this.logger.debug("> {}", (Object)encrypted);
            Request request = new Request.Builder().url(url).addHeader("Content-Type", "application/json").addHeader("Authorization", this.mqttConfig.getAuthorization()).addHeader("X-Alarm-ID", String.valueOf(id)).post(RequestBody.create((String)encrypted, (MediaType)JSON)).build();
            Call call = this.client.newCall(request);
            response = call.execute();
            if (response.isSuccessful()) {
                this.logger.debug("Alarm erfolgreich via HTTP POST versendet");
                return;
            }
            try {
                this.logger.warn("Fehler beim Versand des Alarms via HTTP POST an {} ({}:{})", new Object[]{url, response.code(), response.message()});
                throw new FE2HttpException(String.format("Fehler beim Versand des Alarms via HTTP POST: %s", response.message()));
            }
            catch (Exception e) {
                this.recover(e, message);
            }
        }
    }

    public void recover(Exception e, String message) {
        this.logger.warn("Fehler beim Versand des Alarms via HTTP, verwende MQTT");
        this.logger.debug(e.getLocalizedMessage(), (Throwable)e);
        this.mqttService.handleAlarm(message, ESubTopic.Alarm);
    }

    public void handleHeartbeat() throws FE2HttpException {
        HttpAlarmConfig config = this.configService.getHttpAlarmConfig();
        String host = config.getHost();
        String url = String.format("%s/rest/external/ioespa/%s/heartbeat", host, this.mqttConfig.getId());
        try (Response response = null;){
            Request request = new Request.Builder().url(url).addHeader("Content-Type", "application/json").addHeader("Authorization", this.mqttConfig.getAuthorization()).addHeader("X-Heartbeat-ID", RandomStringUtils.random((int)32, (boolean)true, (boolean)true).concat("_").concat(Long.toString(AlarmCounter.getHeartbeat().incrementAndGet()))).head().build();
            Call call = this.client.newCall(request);
            response = call.execute();
            if (response.isSuccessful()) {
                this.logger.debug("Lebenszeichen erfolgreich via HTTP POST versendet ({}: {})", (Object)response.code(), (Object)response.message());
                return;
            }
            try {
                this.logger.warn("Fehler beim Versand des Lebenszeichens via HTTP POST an ({}:{}, {})", new Object[]{url, response.code(), response.message()});
                throw new GenericException(String.format("Fehler beim Versand des Lebenszeichens via HTTP POST: %s", response.message()));
            }
            catch (Exception e) {
                throw new FE2HttpException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

