/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.services.ioespa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.alamos.ioespa.data.alarm.AlarmData;
import de.alamos.ioespa.data.mqtt.ESubTopic;
import de.alamos.ioespa.helper.LoggerHelper;
import de.alamos.ioespa.helper.exceptions.FE2HttpException;
import de.alamos.ioespa.services.MqttService;
import de.alamos.ioespa.services.TimeService;
import de.alamos.ioespa.services.ioespa.AlarmCounter;
import de.alamos.ioespa.services.ioespa.HttpAlarmService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"espa"})
public class AlarmService {
    private final Logger logger = LoggerHelper.getLogger(this.getClass());
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final MqttService mqttService;
    private final HttpAlarmService httpAlarmService;
    private final TimeService timeService;
    private final ObjectMapper objectMapper;

    @Autowired
    public AlarmService(MqttService mqttService, HttpAlarmService httpAlarmService, TimeService timeService) {
        this.mqttService = mqttService;
        this.httpAlarmService = httpAlarmService;
        this.timeService = timeService;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void handleHeartbeat() {
        try {
            if (this.httpAlarmService.isActive()) {
                this.httpAlarmService.handleHeartbeat();
            }
        }
        catch (FE2HttpException e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            this.logger.warn("Hearbeat konnte nicht via HTTP verschickt werden, nutze MQTT...");
        }
    }

    public void handleAlarm(String message, String port) {
        this.logger.debug("handleAlarm()");
        long counter = AlarmCounter.getAlarm().incrementAndGet();
        this.logger.debug("Aktueller Counter: {}", (Object)counter);
        Future<?> submitted = this.executor.submit(() -> {
            AlarmData alarmData = new AlarmData(this.timeService.getAdjustedSystemTime(), message, port, counter);
            try {
                String payload = this.objectMapper.writeValueAsString((Object)alarmData);
                this.logger.trace(payload);
                if (this.httpAlarmService.isActive()) {
                    this.logger.info("Verschicke Alarm via HTTP...");
                    this.httpAlarmService.handleAlarm(payload, counter);
                } else {
                    this.logger.info("Verschicke Alarm via MQTT...");
                    this.mqttService.handleAlarm(payload, ESubTopic.Alarm);
                }
            }
            catch (JsonProcessingException e) {
                this.logger.error("Fehler beim Konvertieren der AlarmData zur JSON", (Throwable)e);
            }
            this.logger.debug("handleAlarm() abgeschlossen");
        });
        this.logger.debug(submitted.toString());
    }
}

