/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller.ioprint;

import de.alamos.ioespa.data.config.IOCredentials;
import de.alamos.ioespa.rest.responses.status.EAppName;
import de.alamos.ioespa.services.FileService;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.Generated;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@Profile(value={"print"})
public class FilesController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FilesController.class);
    private final IOCredentials credentials;
    private final FileService fileService;

    public FilesController(IOCredentials credentials, FileService fileService) {
        this.credentials = credentials;
        this.fileService = fileService;
    }

    @GetMapping(value={"/files/{fileName}"})
    public void getFile(HttpServletResponse response, @PathVariable String fileName) throws IOException {
        response.setHeader("Content-Disposition", String.format("attachment;filename=%s", fileName));
        response.setContentType("application/octet-stream");
        response.setStatus(200);
        File file = new File("config/pdfs/" + fileName);
        try (FileInputStream in = new FileInputStream(file);){
            ServletOutputStream out = response.getOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.close();
        }
    }

    @GetMapping(value={"/files"})
    public String getFilesPage(Model model, RedirectAttributes redirAttrs) {
        model.addAttribute("appName", (Object)EAppName.IOPrint);
        model.addAttribute("folderInfo", (Object)this.fileService.getFolderInfo());
        model.addAttribute("files", (Object)this.fileService.getAllPdfFiles());
        model.addAttribute("defaultPassword", (Object)(!this.credentials.isWasChanged() ? 1 : 0));
        return "files";
    }
}

