/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller.ioespa;

import de.alamos.ioespa.data.config.EspaConfig;
import de.alamos.ioespa.data.config.IOCredentials;
import de.alamos.ioespa.espa.ESPAInput;
import de.alamos.ioespa.espa.utils.SerialLogCollector;
import de.alamos.ioespa.rest.responses.espa.EspaModel;
import de.alamos.ioespa.services.config.EspaConfigService;
import de.alamos.ioespa.services.ioespa.EspaControlService;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@Profile(value={"espa"})
public class EspaConfigController {
    private final EspaConfigService espaConfigService;
    private final EspaControlService espaControlService;
    private final IOCredentials credentials;
    private final SerialLogCollector serialLogCollector;

    public EspaConfigController(EspaConfigService espaConfigService, EspaControlService espaControlService, IOCredentials credentials, SerialLogCollector serialLogCollector) {
        this.espaConfigService = espaConfigService;
        this.espaControlService = espaControlService;
        this.credentials = credentials;
        this.serialLogCollector = serialLogCollector;
    }

    @GetMapping(value={"/espa"})
    public String getConfigPage(Model model, RedirectAttributes redirAttrs) {
        model.addAttribute("response", (Object)new EspaModel(this.espaConfigService.getEspaConfig()));
        model.addAttribute("config", (Object)this.espaConfigService.getEspaConfig());
        model.addAttribute("defaultPassword", (Object)(!this.credentials.isWasChanged() ? 1 : 0));
        model.addAttribute("logs", (Object)this.serialLogCollector.getAll());
        model.addAttribute("lastAlarms", this.espaControlService.getInputs().stream().map(ESPAInput::getLastAlarms).flatMap(Collection::stream).collect(Collectors.toList()));
        return "espa";
    }

    @PostMapping(value={"/espa"})
    public String postConfig(@ModelAttribute EspaConfig espaConfig, RedirectAttributes redirAttrs) {
        this.espaConfigService.setEspaConfig(espaConfig);
        this.espaControlService.restart();
        redirAttrs.addFlashAttribute("success", (Object)"Espa-Config erfolgreich gespeichert");
        return "redirect:/status";
    }
}

