/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.rest.controller;

import de.alamos.ioespa.data.config.ConfigHolder;
import de.alamos.ioespa.data.config.IOCredentials;
import de.alamos.ioespa.data.config.MqttConfig;
import de.alamos.ioespa.rest.responses.MqttResponse;
import de.alamos.ioespa.services.AppInfoService;
import de.alamos.ioespa.services.MqttService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class MqttController {
    private final MqttConfig config;
    private final MqttService mqttService;
    private final IOCredentials credentials;
    private final AppInfoService appInfoService;

    public MqttController(ConfigHolder configHolder, MqttService mqttService, IOCredentials credentials, AppInfoService appInfoService) {
        this.config = configHolder.getMqttConfig();
        this.mqttService = mqttService;
        this.credentials = credentials;
        this.appInfoService = appInfoService;
    }

    @GetMapping(value={"/mqtt"})
    public String mqtt(Model model, RedirectAttributes redirAttrs) {
        if (this.config == null) {
            redirAttrs.addFlashAttribute("error", (Object)"Noch nicht vollst\u00e4ndig konfiguriert");
            return "redirect:/status";
        }
        MqttResponse res = new MqttResponse();
        res.setConnected(this.mqttService.isConnected());
        res.setFallbackConnected(this.mqttService.isFallbackConnected());
        res.setClients(this.mqttService.getClientIds().size());
        res.setReconnectionAttempts(this.mqttService.getReconnectionAttempts());
        res.setReconnectionDelay(this.mqttService.getCurrentReconnectionDelay());
        res.setReconnecting(this.mqttService.isReconnecting());
        res.setLastDisconnectTime(this.mqttService.getLastDisconnectTime());
        res.setLastSuccessfulConnection(this.mqttService.getLastSuccessfulConnection());
        model.addAttribute("deviceId", (Object)this.config.getId());
        model.addAttribute("response", (Object)res);
        model.addAttribute("defaultPassword", (Object)(!this.credentials.isWasChanged() ? 1 : 0));
        model.addAttribute("appName", (Object)this.appInfoService.getAppName());
        String mqttErrorMsg = this.mqttService.getMqttErrorMsg();
        model.addAttribute("hasError", (Object)StringUtils.isNotBlank((CharSequence)mqttErrorMsg));
        model.addAttribute("mqttErrorMsg", (Object)mqttErrorMsg);
        return "mqtt";
    }
}

