/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.helper;

import de.alamos.ioespa.data.config.ConfigFile;
import de.alamos.ioespa.helper.LoggerHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PropertyFileHelper {
    private static final Logger LOGGER = LoggerHelper.getLogger(PropertyFileHelper.class);

    private PropertyFileHelper() {
    }

    public static void storeInFile(ConfigFile configFile, File file) {
        PropertyFileHelper.storeInFile((Properties)configFile.toProperties(), (File)file, (String)configFile.getClass().getSimpleName());
    }

    public static void storeInFile(Properties props, File file, String logName) {
        boolean created = file.getParentFile().mkdir();
        LOGGER.debug("{} created: {}", (Object)file.getParentFile().getAbsolutePath(), (Object)created);
        try (FileOutputStream stream = new FileOutputStream(file);){
            props.store(stream, null);
            LOGGER.info("{} unter {} gespeichert", (Object)logName, (Object)file.getAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.warn("Fehler beim Schreiben der Config", (Throwable)e);
        }
    }

    public static Optional<Properties> loadProperties(File file) {
        Optional<Properties> optional;
        Properties props = new Properties();
        FileInputStream stream = new FileInputStream(file);
        try {
            props.load(stream);
            optional = Optional.of(props);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Datei {} konnte nicht geladen werden", (Object)file.getAbsolutePath());
                return Optional.empty();
            }
        }
        stream.close();
        return optional;
    }
}

