/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.espa;

import de.alamos.ioespa.espa.EEspaCallSign;
import de.alamos.ioespa.helper.SignedByteHelper;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class EspaLogMessageCreator {
    private EspaLogMessageCreator() {
    }

    public static String createEspaLog(List<Byte> scannedBytes) {
        return EspaLogMessageCreator.createEspaLog(scannedBytes, (boolean)true);
    }

    public static String createEspaLog(List<Byte> scannedBytes, boolean convertBytes) {
        boolean hasETX = false;
        Object[] parsedStrings = new String[scannedBytes.size()];
        for (int i = 0; i < scannedBytes.size(); ++i) {
            EEspaCallSign callSign = EEspaCallSign.findByByte((byte)scannedBytes.get(i));
            if (hasETX) {
                parsedStrings[i] = String.format("[%d]", scannedBytes.get(i));
                hasETX = false;
                continue;
            }
            if (callSign == null) {
                if (convertBytes) {
                    parsedStrings[i] = Character.toString(SignedByteHelper.convert((byte)scannedBytes.get(i)));
                    continue;
                }
                parsedStrings[i] = Character.toString(scannedBytes.get(i).byteValue());
                continue;
            }
            parsedStrings[i] = callSign.getReadableCallSign();
            if (callSign != EEspaCallSign.ETX) continue;
            hasETX = true;
        }
        return StringUtils.join((Object[])parsedStrings);
    }

    public static String createEspaLog(String s) {
        StringBuilder builder = new StringBuilder();
        boolean hasETX = false;
        for (char c : s.toCharArray()) {
            EEspaCallSign callSign = EEspaCallSign.findByByte((byte)((byte)c));
            if (hasETX) {
                builder.append(String.format("[%d]", c));
                hasETX = false;
                continue;
            }
            if (callSign == null) {
                builder.append(c);
                continue;
            }
            builder.append(callSign.getReadableCallSign());
            if (callSign != EEspaCallSign.ETX) continue;
            hasETX = true;
        }
        return builder.toString();
    }
}

