/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.data.config;

import de.alamos.ioespa.data.config.ConfigFile;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class AppConfig
implements ConfigFile {
    private Long numberSavedFiles;
    private Long cleaningInterval;
    private String logLevelStr;
    private Boolean updatedNow;
    private Boolean duplexOn;
    private String webHook;
    private String secondPublicKey;
    public static final String DEFAULT_LOG_LEVEL = "DEBUG";
    public static final String DEFAULT_LOG_LEVEL_AFTER_CONFIGURED = "INFO";
    public static final boolean DEFAULT_DUPLEX_ON = true;

    public Properties toProperties() {
        Properties props = new Properties();
        props.setProperty("numberSavedFiles", String.valueOf(this.numberSavedFiles));
        props.setProperty("cleaningInterval", String.valueOf(this.cleaningInterval));
        props.setProperty("logLevelStr", this.logLevelStr);
        props.setProperty("updatedNow", String.valueOf(this.updatedNow));
        props.setProperty("duplexOn", String.valueOf(this.duplexOn));
        props.setProperty("webHook", StringUtils.isBlank((CharSequence)this.webHook) ? "" : this.webHook);
        props.setProperty("secondPublicKey", StringUtils.isBlank((CharSequence)this.secondPublicKey) ? "" : this.secondPublicKey);
        return props;
    }

    public String getLogLevelStr() {
        if (this.updatedNow != null && this.updatedNow.booleanValue() && !"TRACE".equals(this.logLevelStr)) {
            return DEFAULT_LOG_LEVEL;
        }
        return this.logLevelStr;
    }

    public boolean hasWebHook() {
        return StringUtils.isNotBlank((CharSequence)this.webHook);
    }

    public boolean hasSecondPublicKey() {
        return StringUtils.isNotBlank((CharSequence)this.secondPublicKey);
    }

    public boolean isDuplexOn() {
        return this.duplexOn != null ? this.duplexOn : true;
    }

    @Generated
    public Long getNumberSavedFiles() {
        return this.numberSavedFiles;
    }

    @Generated
    public Long getCleaningInterval() {
        return this.cleaningInterval;
    }

    @Generated
    public Boolean getUpdatedNow() {
        return this.updatedNow;
    }

    @Generated
    public Boolean getDuplexOn() {
        return this.duplexOn;
    }

    @Generated
    public String getWebHook() {
        return this.webHook;
    }

    @Generated
    public String getSecondPublicKey() {
        return this.secondPublicKey;
    }

    @Generated
    public void setNumberSavedFiles(Long numberSavedFiles) {
        this.numberSavedFiles = numberSavedFiles;
    }

    @Generated
    public void setCleaningInterval(Long cleaningInterval) {
        this.cleaningInterval = cleaningInterval;
    }

    @Generated
    public void setLogLevelStr(String logLevelStr) {
        this.logLevelStr = logLevelStr;
    }

    @Generated
    public void setUpdatedNow(Boolean updatedNow) {
        this.updatedNow = updatedNow;
    }

    @Generated
    public void setDuplexOn(Boolean duplexOn) {
        this.duplexOn = duplexOn;
    }

    @Generated
    public void setWebHook(String webHook) {
        this.webHook = webHook;
    }

    @Generated
    public void setSecondPublicKey(String secondPublicKey) {
        this.secondPublicKey = secondPublicKey;
    }

    @Generated
    public AppConfig() {
    }
}

