/*
 * Decompiled with CFR 0.152.
 */
package de.alamos.ioespa.data;

import java.text.StringCharacterIterator;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileInfo {
    private String fileName;
    private String externalId;
    private String timestamp;
    private String sizeInMb;
    private static DateTimeFormatter df = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss z");

    public FileInfo(String fileName, Long time, long sizeInBytes) {
        this.fileName = fileName;
        this.sizeInMb = FileInfo.humanReadableByteCountBin((long)sizeInBytes);
        this.timestamp = new Date(time).toInstant().atZone(ZoneId.of("Europe/Berlin")).format(df);
    }

    public static String humanReadableByteCountBin(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return bytes + " B";
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return String.format("%.1f %ciB", (double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current()));
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getExternalId() {
        return this.externalId;
    }

    @Generated
    public String getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getSizeInMb() {
        return this.sizeInMb;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Generated
    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setSizeInMb(String sizeInMb) {
        this.sizeInMb = sizeInMb;
    }

    @Generated
    public FileInfo() {
    }

    @Generated
    public FileInfo(String fileName, String externalId, String timestamp, String sizeInMb) {
        this.fileName = fileName;
        this.externalId = externalId;
        this.timestamp = timestamp;
        this.sizeInMb = sizeInMb;
    }
}

